/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.util.Hashtable;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.NativeConfigTemplate3D;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;

class Win32NativeConfigTemplate3D
extends NativeConfigTemplate3D {
    private static final boolean debug = false;

    Win32NativeConfigTemplate3D() {
    }

    native int choosePixelFormat(long var1, int var3, int[] var4, long[] var5);

    static native void freePixelFormatInfo(long var0);

    native boolean isStereoAvailable(long var1, boolean var3);

    native boolean isDoubleBufferAvailable(long var1, boolean var3);

    native boolean isSceneAntialiasingAccumAvailable(long var1, boolean var3);

    native boolean isSceneAntialiasingMultisampleAvailable(long var1, boolean var3, int var4);

    native int getStencilSize(long var1, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        int[] nArray = new int[10];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        nArray[9] = graphicsConfigTemplate3D.getStencilSize();
        int n2 = NativeScreenInfo.getNativeScreenInfo().getScreen((GraphicsDevice)win32GraphicsDevice);
        long[] lArray = new long[]{-1L};
        int n3 = this.choosePixelFormat(0L, n2, nArray, lArray);
        if (n3 < 0) {
            return null;
        }
        Win32GraphicsConfig win32GraphicsConfig = Win32GraphicsConfig.getConfig((Win32GraphicsDevice)win32GraphicsDevice, (int)0);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            if (Canvas3D.graphicsConfigTable.get(win32GraphicsConfig) == null) {
                GraphicsConfigInfo graphicsConfigInfo = new GraphicsConfigInfo(graphicsConfigTemplate3D);
                graphicsConfigInfo.setPrivateData(new Long(lArray[0]));
                Canvas3D.graphicsConfigTable.put((GraphicsConfiguration)win32GraphicsConfig, graphicsConfigInfo);
            } else {
                Win32NativeConfigTemplate3D.freePixelFormatInfo(lArray[0]);
            }
        }
        return win32GraphicsConfig;
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        long[] lArray;
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        int[] nArray = new int[10];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        nArray[9] = graphicsConfigTemplate3D.getStencilSize();
        int n2 = NativeScreenInfo.getNativeScreenInfo().getScreen((GraphicsDevice)win32GraphicsDevice);
        int n3 = this.choosePixelFormat(0L, n2, nArray, lArray = new long[1]);
        return n3 >= 0;
    }

    boolean hasStereo(Canvas3D canvas3D) {
        return this.isStereoAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    int getStencilSize(Canvas3D canvas3D) {
        return this.getStencilSize(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        return this.isDoubleBufferAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        return this.isSceneAntialiasingAccumAvailable(canvas3D.fbConfig, canvas3D.offScreen);
    }

    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        int n2 = NativeScreenInfo.getNativeScreenInfo().getScreen((GraphicsDevice)win32GraphicsDevice);
        return this.isSceneAntialiasingMultisampleAvailable(canvas3D.fbConfig, canvas3D.offScreen, n2);
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

